<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Helper_StatsFilter
{
    protected $from;

    protected $to;

    protected $filter;

    protected $error;

    protected $require_filter;

    public function __construct()
    {

    }

    public function getFilteredItems($items)
    {
        $filteredItems=array();

        foreach($this->filter AS $content_id) {
            if(isset($items[$content_id])) {
                $filteredItems[$content_id] = $items[$content_id];
            }
        }

        return $filteredItems;
    }

    public function validateFilter()
    {
        if (!$this->to || !$this->from || $this->to <= $this->from) {
            $error = new XenForo_Phrase('xcas_please_select_correct_date_interval');
            $this->error=$error->render();
            return false;
        }

        if($this->getRequireFilter() AND empty($this->filter)) {
            $error= new XenForo_Phrase('xcas_please_select_select_any_item_in_filter');
            return false;
        }

        return true;
    }

    /**
     * @return mixed
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * @param mixed $filter
     */
    public function setFilter($filter)
    {
        $this->filter = $filter;
    }

    /**
     * @return mixed
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * @param mixed $from
     */
    public function setFrom($from)
    {
        $this->from = $from;
    }

    /**
     * @return mixed
     */
    public function getFrom()
    {
        return $this->from;
    }

    /**
     * @param mixed $to
     */
    public function setTo($to)
    {
        $this->to = $to;
    }

    /**
     * @return mixed
     */
    public function getTo()
    {
        return $this->to;
    }

    /**
     * @param mixed $require_filter
     */
    public function setRequireFilter($require_filter)
    {
        $this->require_filter = $require_filter;
    }

    /**
     * @return mixed
     */
    public function getRequireFilter()
    {
        return $this->require_filter;
    }


}